#pragma once

#include <string>
#include <memory>
#include <utility>
#include <common/uid_map.h>

namespace yimap {

class ImapContext;
struct FolderInfo;

struct SpamReport
{

    struct SeenMids
    {
        std::string mid;
        std::string stid;
        time_t receiveTime;
        bool seen;
    };
    using SeenMidsList = std::list<SeenMids>;

    static std::unique_ptr<SpamReport> make(
        const ImapContext& sinfo,
        const UidMap& uids,
        const BodyMetadataByMid& bodyMeta,
        const std::string type,
        const std::string& fromFolder,
        const std::string toFolder = "",
        const std::string& flag = "");

    std::string sessionId;
    std::string uid;
    std::string suid;
    std::string ip;

    std::string fromFolder;
    std::string toFolder;

    std::string type;
    std::string flag;
    std::string client;

    SeenMidsList midList;

    void logToTskv() const;

    static const std::string ACTION_FLAG;
    static const std::string ACTION_COPY;
    static const std::string ACTION_MOVE;

protected:
    SpamReport(
        const ImapContext& context,
        const UidMap& uids,
        const BodyMetadataByMid& bodyMeta,
        const std::string type,
        const std::string& fromFolder,
        const std::string toFolder = "",
        const std::string& flag = "");
};

} // namespace yimap
