#pragma once

#include <common/types.h>

#include <ymod_ratecontroller/rate_controller.h>
#include <yplatform/future/future.hpp>
#include <yplatform/reactor.h>

namespace yimap { namespace backend {

class ThreadPool
{
    using rate_controller_ptr = ymod_ratecontroller::rate_controller_ptr;

public:
    ThreadPool(boost::asio::io_service& io, rate_controller_ptr rate_controller)
        : io_(io), rate_controller_(rate_controller)
    {
    }

    template <typename Task, typename Result = decltype(Task())>
    Future<Result> post(ContextPtr ctx, const Task& task)
    {
        Promise<Result> promise;
        auto rc_task = [io = &io_, promise, task](auto&& err, auto&& completionHandler) mutable {
            if (err)
            {
                promise.set_exception(std::runtime_error("post task error: "s + err.message()));
                completionHandler();
                return;
            }
            io->post([task, promise, completionHandler]() mutable {
                try
                {
                    promise.set(task());
                }
                catch (...)
                {
                    promise.set_exception(std::current_exception());
                }
                completionHandler();
            });
        };
        rate_controller_->post(rc_task, ctx->uniq_id(), ctx->deadline());
        return promise;
    }

private:
    boost::asio::io_service& io_;
    rate_controller_ptr rate_controller_;
};

using ThreadPoolPtr = std::shared_ptr<ThreadPool>;

}}
