#pragma once

#include <user_journal/parameters/folders.h>
#include <user_journal/parameters/message.h>
#include <user_journal/parameters/parameters.h>
#include <user_journal/parameters/parameter_id.h>

namespace user_journal_types {

template <user_journal::Operation::Enum operationT, typename... Args>
using AccountParams = user_journal::parameters::
    OperationParameters<user_journal::Target::account, operationT, Args...>;

using Authorization = AccountParams<user_journal::Operation::authorization>;

template <user_journal::Operation::Enum operationT, typename... Args>
using MessageParams = user_journal::parameters::
    OperationParameters<user_journal::Target::message, operationT, Args...>;

using FetchBody =
    MessageParams<user_journal::Operation::fetch_body, user_journal::parameters::id::mids>;

} // namespace user_journal_types
