#pragma once

#include "config.h"
#include "xiva_event.h"
#include "subscription_control.h"

#include <backend/backend.h>
#include <backend/handlers.h>
#include <common/imap_context.h>
#include <common/log/logger.h>
#include <common/types.h>

namespace yimap::backend {

class XivaDispatcher;
using XivaDispatcherPtr = std::shared_ptr<XivaDispatcher>;

class XivaNotificationsBackend
    : public NotificationsBackend
    , public std::enable_shared_from_this<XivaNotificationsBackend>
{
public:
    XivaNotificationsBackend(
        ImapContextPtr context,
        XivaDispatcherPtr dispatcher,
        ControlConfigPtr config);

    ~XivaNotificationsBackend();

    void subscribe(WeakEventHandlerPtr handler) override;

    // called by dispatcher
    Future<bool> handleEvent(const XivaEvent& xivaEvent);

    const string& userId() const;
    const string& sessionId() const;

private:
    void addHandler(EventHandlerPtr handler);
    void addWeakHandler(WeakEventHandlerPtr handler);
    bool processEvent(ImapEventPtr event);
    ImapEventPtr createImapEvent(const XivaEvent& xivaEvent);

    void spawnControllerOnce();

    ImapContextPtr context;
    IOService& ioService;
    std::set<EventHandlerPtr> handlers;
    XivaDispatcherPtr dispatcher;
    ControlConfigPtr config;

    std::shared_ptr<SubscriptionControl> controller;

    yplatform::log::source xivaLog;
};

typedef std::shared_ptr<XivaNotificationsBackend> XivaNotificationsBackendPtr;
typedef std::weak_ptr<XivaNotificationsBackend> XivaNotificationsBackendWeakPtr;

}
