#pragma once

#include <common/helpers/helpers.h>
#include <common/types.h>
#include <map>

namespace yimap::backend {

struct ControlConfig
{
    ControlConfig(const Ptree& config)
        : ctoken(config.get("ctoken", ""))
        , hostName(HostId::create().hostName)
        , httpPort(config.get("http_port", static_cast<unsigned short>(10080)))
        , service(config.get("service", "mail"))
        , events(readEvents(config))
    {
        std::ostringstream ss;
        ss << "http://" << hostName << ":" << httpPort
           << "/notify?subscription_id=${subscription-id}";
        callback = ss.str();
    }

    const string ctoken;
    string hostName;
    const unsigned short httpPort;
    string callback;
    string service;

    const std::map<string, string> events;

private:
    std::map<string, string> readEvents(const Ptree& config) const
    {
        std::map<string, string> result;
        auto eventsConfig = config.get_child_optional("events");
        if (!eventsConfig) return result;

        for (auto&& eventNode : *eventsConfig)
        {
            auto eventName = eventNode.second.get("<xmlattr>.operation", "");
            auto eventAction = eventNode.second.get("<xmlattr>.action", "");
            result[eventName] = eventAction;
        }

        return result;
    }
};

typedef std::shared_ptr<ControlConfig> ControlConfigPtr;

}
