#pragma once

#include "xiva_event.h"
#include <common/types.h>
#include <ymod_webserver/response.h>

namespace yimap::backend {

class XivaNotificationsBackend;
typedef std::shared_ptr<XivaNotificationsBackend> XivaNotificationsBackendPtr;
typedef std::weak_ptr<XivaNotificationsBackend> XivaNotificationsBackendWeakPtr;

// Accepts http messages from xiva, parse body, find and call handler by uid.
class XivaDispatcher : public std::enable_shared_from_this<XivaDispatcher>
{
public:
    XivaDispatcher() : xivaLog(YGLOBAL_LOG_SERVICE, "xiva_log")
    {
    }

    void subscribe(
        const string& uid,
        const string& sessionId,
        XivaNotificationsBackendWeakPtr handler);
    void unsubscribe(const string& uid, const string& sessionId);

    void process(ymod_webserver::http::stream_ptr stream);
    void handleEvent(XivaEvent&& xivaEvent, ymod_webserver::http::stream_ptr stream);
    XivaNotificationsBackendPtr findHandler(const string& uid);

private:
    void respondProcessed(
        ymod_webserver::http::stream_ptr stream,
        bool processed,
        const string& subscriptionId);

    typedef std::multimap<string, XivaNotificationsBackendWeakPtr> HandlersMap;
    HandlersMap handlers;
    mutable std::mutex mux;
    yplatform::log::source xivaLog;
};

using XivaDispatcherPtr = std::shared_ptr<XivaDispatcher>;

}