#include "module.h"
#include "dispatcher.h"
#include <yplatform/module_registration.h>
#include <ymod_webserver/server.h>

namespace yimap::backend {

XivaModule::XivaModule(const Ptree& conf)
{
    config = std::make_shared<ControlConfig>(conf);
    xivaDispatcher = std::make_shared<XivaDispatcher>();
    auto webServer = yplatform::find<ymod_webserver::server>("web_server");
    webServer->bind(
        "xiva",
        { "/notify", "/notify/" },
        std::bind(&XivaDispatcher::process, xivaDispatcher, std::placeholders::_1));
    webServer->bind("xiva", { "/ping" }, [](ymod_webserver::http::stream_ptr stream) {
        stream->result(ymod_webserver::codes::ok, "pong");
    });
}

XivaNotificationsBackendPtr XivaModule::createBackend(ImapContextPtr context)
{
    return std::make_shared<XivaNotificationsBackend>(context, xivaDispatcher, config);
}

}

DEFINE_SERVICE_OBJECT(yimap::backend::XivaModule)
