#pragma once

#include "config.h"
#include "backend.h"

#include <common/imap_context.h>
#include <common/types.h>

namespace yimap::backend {

class XivaDispatcher;
using XivaDispatcherPtr = std::shared_ptr<XivaDispatcher>;

class XivaModule : public yplatform::module
{
public:
    XivaModule(const Ptree& xml);

    XivaNotificationsBackendPtr createBackend(ImapContextPtr context);

private:
    ControlConfigPtr config;
    XivaDispatcherPtr xivaDispatcher;
};

}