#pragma once

#include <common/types.h>
#include <msgpack.hpp>
#include <msgpack/type.hpp>

namespace yimap::backend {

struct XivaEvent
{
    string uid;
    string suid;
    string service;
    string operation;
    string subscriptionId;
    string transitId;
    int64_t eventTs = 0;
    std::map<string, string> data;
    string raw_data;
    string lcn;
    string session_key;
    uint64_t localId = 0;
    bool bright = true;

    MSGPACK_DEFINE(
        uid,
        suid,
        service,
        operation,
        lcn,
        session_key,
        data,
        raw_data,
        bright,
        transitId,
        localId,
        eventTs);
};

}