#include <backend/handlers.h>
#include <network/session.h>

namespace yimap {

class PerSessionEventHandler : public ImapEventHandler
{
    NetworkSessionWeakPtr session;

public:
    PerSessionEventHandler(NetworkSessionPtr session) : session(session)
    {
    }

    bool onEvent(ImapEventPtr event) override
    {
        auto captured = session.lock();
        if (!captured) return false;

        auto& ioService = captured->getContext()->ioService;
        ioService.post([event, session = captured]() mutable {
            if (event->action() == "drop_session" && event->checkConditions(session->getContext()))
            {
                // TODO log
                session->shutdown();
            }
        });
        return true;
    }
};

}
