#include "imap_command.h"
#include "response/capability.hpp"
#include <yplatform/yield.h>

namespace yimap {

struct Capability : ImapCommand
{
    using YieldCtx = yplatform::yield_context<Capability>;

    Capability(ImapCommandArgs& cmdArgs) : ImapCommand(cmdArgs)
    {
    }

    void exec() override
    {
        yplatform::spawn(ioService(), yplatform::shared_from(this));
    }

    void operator()(YieldCtx yieldCtx)
    {
        reenter(yieldCtx)
        {
            sendClient() << CapabilityResponse(*imapContext, *settings_);
            yield completeOkAndOutputDiff().then(yieldCtx);
        }
    }

    void operator()(YieldCtx::exception_type exception)
    {
        try
        {
            std::rethrow_exception(exception);
        }
        catch (const std::exception& e)
        {
            completeWithException(e);
        }
    }
};

CommandPtr CommandCapability(ImapCommandArgs& commandArgs)
{
    return CommandPtr(new Capability(commandArgs));
}

}

#include <yplatform/unyield.h>