#include "imap_command.h"

namespace yimap {

// Implementation of ENABLE extention. RFC 5161.
// Now we have nothing to ENABLE, but we can monitor
// what extentions required by clients.
struct Enable : ImapAuthenticatedCommand
{
    Enable(ImapCommandArgs& cmdArgs) : ImapAuthenticatedCommand(cmdArgs)
    {
    }

    void exec() override
    {
        if (sufficientArguments())
        {
            sendEnabled();
            completeOk();
        }
        else
        {
            completeBadEmptyArgumentsList();
        }
    }

    bool sufficientArguments() const
    {
        return cargsSize() > 1;
    }

    void logArguments()
    {
        for (auto i = 1u; i < cargsSize(); i++)
        {
            logger->logDebug() << " debug ENABLE cmd: " << carg(i);
        }
    }

    void sendEnabled()
    {
        sendClient() << "* ENABLED\r\n";
    }

    void completeBadEmptyArgumentsList()
    {
        completeBad("[CLIENTBUG]", "Empty argument list");
    }
};

CommandPtr CommandEnable(ImapCommandArgs& commandArgs)
{
    return CommandPtr(new Enable(commandArgs));
}

}
