#include "factory.h"
#include <common/commands.h>
#include <common/tree.h>

namespace yimap {

CommandPtr CommandAuthenticate(ImapCommandArgs& commandArgs);
CommandPtr CommandLogin(ImapCommandArgs& commandArgs);
CommandPtr CommandLsub(ImapCommandArgs& commandArgs);
CommandPtr CommandList(ImapCommandArgs& commandArgs);
CommandPtr CommandXList(ImapCommandArgs& commandArgs);
CommandPtr CommandLogout(ImapCommandArgs& commandArgs);
CommandPtr CommandNoop(ImapCommandArgs& commandArgs);
CommandPtr CommandId(ImapCommandArgs& commandArgs);
CommandPtr CommandIdle(ImapCommandArgs& commandArgs);
CommandPtr CommandNotify(ImapCommandArgs& commandArgs);
CommandPtr CommandCapability(ImapCommandArgs& commandArgs);
CommandPtr CommandCheck(ImapCommandArgs& commandArgs);

CommandPtr CommandEnable(ImapCommandArgs& commandArgs);
CommandPtr CommandStatus(ImapCommandArgs& commandArgs);
CommandPtr CommandSelect(ImapCommandArgs& commandArgs);
CommandPtr CommandExamine(ImapCommandArgs& commandArgs);
CommandPtr CommandCreate(ImapCommandArgs& commandArgs);
CommandPtr CommandDelete(ImapCommandArgs& commandArgs);
CommandPtr CommandRename(ImapCommandArgs& commandArgs);
CommandPtr CommandSubscribe(ImapCommandArgs& commandArgs);
CommandPtr CommandUnsubscribe(ImapCommandArgs& commandArgs);
CommandPtr CommandFetch(ImapCommandArgs& commandArgs);
CommandPtr CommandSearch(ImapCommandArgs& commandArgs);

CommandPtr CommandUidCopy(ImapCommandArgs& commandArgs);
CommandPtr CommandUidMove(ImapCommandArgs& args);
CommandPtr CommandUidExpunge(ImapCommandArgs& commandArgs);
CommandPtr CommandUidFetch(ImapCommandArgs& commandArgs);
CommandPtr CommandUidSearch(ImapCommandArgs& commandArgs);
CommandPtr CommandUidStore(ImapCommandArgs& commandArgs);

CommandPtr CommandStartTls(ImapCommandArgs& commandArgs);
CommandPtr CommandExpunge(ImapCommandArgs& commandArgs);
CommandPtr CommandClose(ImapCommandArgs& commandArgs);
CommandPtr CommandUnselect(ImapCommandArgs& commandArgs);
CommandPtr CommandStore(ImapCommandArgs& commandArgs);
CommandPtr CommandCopy(ImapCommandArgs& commandArgs);
CommandPtr CommandMove(ImapCommandArgs& args);
CommandPtr CommandAppend(ImapCommandArgs& commandArgs);
CommandPtr CommandNamespace(ImapCommandArgs& commandArgs);

CommandPtr createCommand(CommandASTPtr commandAst, ImapCommandArgs commandArgs)
{
    Trees& trees = commandAst->data.trees;
    if (trees.empty())
    {
        throw std::domain_error("empty AST");
    }
    int commandCode = boost::get<int>(trees[0].value.value());

    switch (commandCode)
    {
    case CMD_AUTHENTICATE:
        return CommandAuthenticate(commandArgs);
    case CMD_LOGIN:
        return CommandLogin(commandArgs);
    case CMD_LSUB:
        return CommandLsub(commandArgs);
    case CMD_LIST:
        return CommandList(commandArgs);
    case CMD_X_LIST:
        return CommandXList(commandArgs);
    case CMD_LOGOUT:
        return CommandLogout(commandArgs);
    case CMD_NOOP:
        return CommandNoop(commandArgs);
    case CMD_ID:
        return CommandId(commandArgs);
    case CMD_IDLE:
        return CommandIdle(commandArgs);
    case CMD_CHECK:
        return CommandNoop(commandArgs);
    case CMD_CAPABILITY:
        return CommandCapability(commandArgs);
    case CMD_ENABLE:
        return CommandEnable(commandArgs);
    case CMD_SELECT:
        return CommandSelect(commandArgs);
    case CMD_EXAMINE:
        return CommandExamine(commandArgs);
    case CMD_CREATE:
        return CommandCreate(commandArgs);
    case CMD_DELETE:
        return CommandDelete(commandArgs);
    case CMD_RENAME:
        return CommandRename(commandArgs);
    case CMD_SUBSCRIBE:
        return CommandSubscribe(commandArgs);
    case CMD_UNSUBSCRIBE:
        return CommandUnsubscribe(commandArgs);
    case CMD_FETCH:
        return CommandFetch(commandArgs);
    case CMD_SEARCH:
        return CommandSearch(commandArgs);
    case CMD_STATUS:
        return CommandStatus(commandArgs);
    case CMD_STARTTLS:
        return CommandStartTls(commandArgs);
    case CMD_EXPUNGE:
        return CommandExpunge(commandArgs);
    case CMD_CLOSE:
        return CommandClose(commandArgs);
    case CMD_UNSELECT:
        return CommandUnselect(commandArgs);
    case CMD_STORE:
        return CommandStore(commandArgs);
    case CMD_COPY:
        return CommandCopy(commandArgs);
    case CMD_MOVE:
        return CommandMove(commandArgs);
    case CMD_APPEND:
        return CommandAppend(commandArgs);
    case CMD_NAMESPACE:
        return CommandNamespace(commandArgs);

    case CMD_UID:
    {
        Trees& cargs = trees[0].children;
        int uidCommand = boost::get<int>(cargs[1].value.value());

        if (uidCommand == CMD_COPY) return CommandUidCopy(commandArgs);
        if (uidCommand == CMD_MOVE) return CommandUidMove(commandArgs);
        if (uidCommand == CMD_UID_EXPUNGE) return CommandUidExpunge(commandArgs);
        if (uidCommand == CMD_FETCH) return CommandUidFetch(commandArgs);
        if (uidCommand == CMD_SEARCH) return CommandUidSearch(commandArgs);
        if (uidCommand == CMD_STORE) return CommandUidStore(commandArgs);
        break;
    }
    default:
        break;
    }

    return CommandPtr();
}

CommandPtr createImapCommand(CommandASTPtr commandAst, ImapCommandArgs commandArgs)
{
    return std::dynamic_pointer_cast<ImapCommand>(createCommand(commandAst, commandArgs));
}

}