#pragma once

#include <common/types.h>
#include <common/lex_ids.h>
#include <common/tree.h>
#include <boost/unordered_set.hpp>

namespace yimap {

struct ihash;
struct iequal_to;
using HeadersSet = boost::unordered_set<string, ihash, iequal_to>;

struct iequal_to
{
    bool operator()(string const& x, string const& y) const;
};

struct ihash
{
    std::size_t operator()(string const& x) const;
};

struct FetchSection
{
    FetchSection() : id(static_cast<lex_ids::ids>(0)), headers()
    {
    }

    lex_ids::ids id;
    string part;
    HeadersSet headers;
};

std::size_t hash_value(FetchSection const& p);
bool operator==(FetchSection const& a, FetchSection const& b);

struct FetchAttribute
{
    FetchAttribute()
    {
    }
    FetchAttribute(const lex_ids::ids& i) : id(i), section()
    {
    }
    FetchAttribute(const std::size_t& i) : id(static_cast<lex_ids::ids>(i)), section()
    {
    }

    lex_ids::ids id;
    FetchSection section;
    std::size_t range_start = 0;
    std::size_t range_size = 0;
};

std::size_t hash_value(FetchAttribute const& p);
bool operator==(FetchAttribute const& a, FetchAttribute const& b);

std::vector<FetchAttribute> createAttributes(const TreeNode& node);

}
