#include "uid_fetcher.h"
#include "size_fetcher.h"
#include "date_fetcher.h"
#include "flags_fetcher.h"
#include "envelope_fetcher.h"
#include "body_structure_fetcher.h"
#include "header_fetcher.h"
#include "body_fetcher.h"
#include "binary_fetcher.h"
#include "mime_fetcher.h"
#include "attribute_fetcher.h"

namespace yimap {

AttributeFetcherPtr createAttributeFetcher(const FetcherArgs& args)
{
    switch (args.att.id)
    {
    case lex_ids::FETCH_ATT_UID:
        return std::make_shared<UidFetcher>();
    case lex_ids::FETCH_ATT_FLAGS:
        return std::make_shared<FlagsFetcher>();
    case lex_ids::FETCH_ATT_INTERNALDATE:
        return std::make_shared<DateFetcher>();
    case lex_ids::FETCH_ATT_ENVELOPE:
        return std::make_shared<EnvelopeFetcher>(args);
    case lex_ids::FETCH_ATT_BODY_STRUCTURE_NONEXT:
        return std::make_shared<BodyStructureFetcher>(args);
    case lex_ids::FETCH_ATT_BODY_STRUCTURE:
        return std::make_shared<ExtendedBodyStructureFetcher>(args);
    case lex_ids::FETCH_ATT_RFC822:
        return std::make_shared<RFC822BodyFetcher>(args);
    case lex_ids::FETCH_ATT_RFC822_TEXT:
        return std::make_shared<RFC822BodyTextFetcher>(args);
    case lex_ids::FETCH_ATT_RFC822_HEADER:
        return std::make_shared<RFC822HeaderFetcher>(args);
    case lex_ids::FETCH_ATT_RFC822_SIZE:
        return std::make_shared<RFC822SizeFetcher>();
    case lex_ids::FETCH_ATT_BODY:
    case lex_ids::FETCH_ATT_BODY_PEEK:
    {
        switch (args.att.section.id)
        {
        case lex_ids::SECTION_MSG_HEADER:
            return std::make_shared<HeaderFetcher>(args);
        case lex_ids::SECTION_MSG_HEADER_FIELDS:
            return std::make_shared<HeaderFieldsFetcher>(args);
        case lex_ids::SECTION_MSG_HEADER_FIELDS_NOT:
            return std::make_shared<HeaderFieldsNotFetcher>(args);
        case lex_ids::SECTION:
        case lex_ids::SECTION_PART:
            return std::make_shared<BodyFetcher>(args);
        case lex_ids::SECTION_MSG_TEXT:
            return std::make_shared<BodyTextFetcher>(args);
        case lex_ids::SECTION_TEXT_MIME:
            return std::make_shared<MimeFetcher>(args);
        default:
            throw std::runtime_error("createAttributeFetcher error: unknown section");
        }
    }
    case lex_ids::FETCH_ATT_BINARY:
    case lex_ids::FETCH_ATT_BINARY_PEEK:
    {
        switch (args.att.section.id)
        {
        case lex_ids::SECTION_MSG_HEADER:
            return std::make_shared<BinaryHeaderFetcher>(args);
        case lex_ids::SECTION_MSG_HEADER_FIELDS:
            return std::make_shared<BinaryHeaderFieldsFetcher>(args);
        case lex_ids::SECTION_MSG_HEADER_FIELDS_NOT:
            return std::make_shared<BinaryHeaderFieldsNotFetcher>(args);
        case lex_ids::SECTION:
        case lex_ids::SECTION_PART:
            return std::make_shared<BinaryFetcher>(args);
        case lex_ids::SECTION_MSG_TEXT:
            return std::make_shared<BinaryTextFetcher>(args);
        case lex_ids::SECTION_TEXT_MIME:
            return std::make_shared<BinaryMimeFetcher>(args);
        default:
            throw std::runtime_error("createAttributeFetcher error: unknown section");
        }
    }
    case lex_ids::FETCH_ATT_BINARY_SIZE:
        return std::make_shared<BinarySizeFetcher>(args);
    default:
        throw std::runtime_error("createAttributeFetcher error: unknown attribute");
    }
}

}
