#pragma once

#include "attribute.h"
#include "fetch_detail.h"
#include <backend/backend.h>
#include <common/message_data.h>
#include <common/imap_context.h>
#include <common/lex_ids.h>
#include <common/types.h>

namespace yimap {

using macs::MimeParts;

struct AttributeFetcher : std::enable_shared_from_this<AttributeFetcher>
{
    using Handler = std::function<void(const string& err, StringPtr value)>;

    virtual ~AttributeFetcher() = default;

    virtual void fetch(
        const MessageData& message,
        const BodyMetadata& bodyMeta,
        const Handler& handler) = 0;
};

using AttributeFetcherPtr = std::shared_ptr<AttributeFetcher>;

struct FetcherArgs
{
    FetchAttribute att;
    backend::MbodyBackendPtr mbodyBackend;
    SettingsCPtr settings;
};

AttributeFetcherPtr createAttributeFetcher(const FetcherArgs& args);

}
