#pragma once

#include "attribute_fetcher.h"
#include "fetch_detail.h"
#include <backend/mbody/body_structure_data.h>

namespace yimap {

struct BodyStructureFetcherBase : AttributeFetcher
{
    FetcherArgs args;

    BodyStructureFetcherBase(const FetcherArgs& args) : args(args)
    {
    }

    void fetch(const MessageData& message, const BodyMetadata& bodyMeta, const Handler& handler)
        override
    {
        auto future = args.mbodyBackend->loadBodyStructure(
            bodyMeta.stid, bodyMeta.mimeParts, args.settings->rawHeadersList);
        future.then(std::bind(
            &BodyStructureFetcherBase::onBodystructure,
            yplatform::shared_from(this),
            p::_1,
            handler));
    }

    void onBodystructure(Future<BodyStructurePtr> future, const Handler& handler)
    {
        try
        {
            auto bodystructure = future.get();
            handler("", makeResponse(bodystructure));
        }
        catch (const std::runtime_error& e)
        {
            handler(e.what(), {});
        }
    }

    virtual StringPtr makeResponse(BodyStructurePtr bodystructure) = 0;
};

struct BodyStructureFetcher : BodyStructureFetcherBase
{
    using BodyStructureFetcherBase::BodyStructureFetcherBase;

    StringPtr makeResponse(BodyStructurePtr bodystructure) override
    {
        std::stringstream stream;
        stream << "BODY ";
        bodystructure->send(stream, false);
        return std::make_shared<string>(stream.str());
    }
};

struct ExtendedBodyStructureFetcher : BodyStructureFetcherBase
{
    using BodyStructureFetcherBase::BodyStructureFetcherBase;

    StringPtr makeResponse(BodyStructurePtr bodystructure) override
    {
        std::stringstream stream;
        stream << "BODYSTRUCTURE ";
        bodystructure->send(stream, true);
        return std::make_shared<string>(stream.str());
    }
};

}
