#pragma once

#include "attribute_fetcher.h"
#include <boost/format.hpp>

namespace yimap {

struct DateFetcher : AttributeFetcher
{
    void fetch(const MessageData& message, const BodyMetadata&, const Handler& handler) override
    {
        struct tm tm;
        ::gmtime_r(&message.time, &tm);

        const char* mon_names[] = { "Jan", "Feb", "Mar", "Apr", "May", "Jun",
                                    "Jul", "Aug", "Sep", "Oct", "Nov", "Dec" };

        boost::format time_fmt("%1$02u-%2%-%3$04u %4$02u:%5$02u:%6$02u +0000");
        time_fmt % tm.tm_mday % mon_names[tm.tm_mon] % (tm.tm_year + 1900) % tm.tm_hour %
            tm.tm_min % tm.tm_sec;

        handler("", std::make_shared<string>("INTERNALDATE \"" + time_fmt.str() + "\""));
    }
};

}
