#pragma once

#include "attribute_fetcher.h"
#include "fetch_detail.h"
#include <backend/envelope.h>

namespace yimap {

struct EnvelopeFetcher : AttributeFetcher
{
    FetcherArgs args;

    EnvelopeFetcher(const FetcherArgs& args) : args(args)
    {
    }

    void fetch(const MessageData& message, const BodyMetadata& bodyMeta, const Handler& handler)
        override
    {
        args.mbodyBackend->loadHeader(
            bodyMeta.stid,
            "",
            bodyMeta.mimeParts,
            std::bind(
                &EnvelopeFetcher::onHeadersLoaded,
                yplatform::shared_from(this),
                p::_1,
                p::_2,
                handler));
    }

    void onHeadersLoaded(const string& err, StringPtr headers, const Handler& handler)
    {
        if (err.size()) return handler(err, {});
        backend::EnvelopeData env;
        bool ok = parse_envelope(*headers, env, args.settings->rawHeadersList);
        if (!ok) return handler("cannot parse message envelope", {});
        std::stringstream stream;
        stream << "ENVELOPE ";
        env.send(stream);
        handler("", std::make_shared<string>(stream.str()));
    }
};

}
