#pragma once

#include "attribute_fetcher.h"

namespace yimap {

struct FlagsFetcher : AttributeFetcher
{
    void fetch(const MessageData& message, const BodyMetadata&, const Handler& handler) override
    {
        std::stringstream stream;
        stream << "FLAGS (";
        message.flags.forEachFlag(detail::EscapeFlag(stream));
        stream << ')';
        handler("", std::make_shared<string>(stream.str()));
    }
};

}
