#pragma once

#include "attribute_fetcher.h"
#include "fetch_detail.h"
#include <backend/envelope.h>
#include <backend/mbody/message_loader.h>
#include <parser/rfc822/rfc822.h>
#include <boost/algorithm/string/join.hpp>

namespace yimap {

struct MimeFetcher : AttributeFetcher
{
    FetcherArgs args;

    MimeFetcher(const FetcherArgs& args) : args(args)
    {
    }

    void fetch(const MessageData& message, const BodyMetadata& bodyMeta, const Handler& handler)
        override
    {
        args.mbodyBackend->loadHeader(
            bodyMeta.stid,
            args.att.section.part,
            bodyMeta.mimeParts,
            std::bind(
                &MimeFetcher::onHeadersLoaded,
                yplatform::shared_from(this),
                p::_1,
                p::_2,
                handler));
    }

    void onHeadersLoaded(const string& err, StringPtr headers, const Handler& handler)
    {
        if (err.size()) return handler(err, {});
        std::stringstream stream;
        stream << "BODY[";
        if (args.att.section.part.size()) stream << args.att.section.part << '.';
        stream << "MIME]";
        if (args.att.range_size) stream << '<' << args.att.range_start << '>';
        stream << " ";
        detail::send_msg(stream, *headers, args.att.range_start, args.att.range_size);
        handler("", std::make_shared<string>(stream.str()));
    }
};

}
