#pragma once

#include "attribute_fetcher.h"

namespace yimap {

struct RFC822SizeFetcher : AttributeFetcher
{
    void fetch(const MessageData& message, const BodyMetadata& bodyMeta, const Handler& handler)
        override
    {
        size_t size = 0;
        for (auto& mime : bodyMeta.mimeParts) // MPROTO-3189
        {
            if (mime.hid() == "1")
            {
                size = mime.offsetEnd();
                break;
            }
        }
        if (!size)
            throw std::runtime_error(
                "size not found in mime parts for message uid="s + std::to_string(message.uid));
        handler("", std::make_shared<string>("RFC822.SIZE " + std::to_string(size)));
    }
};

}
