#include "imap_command.h"

namespace yimap {

struct Id : ImapCommand
{
    Id(ImapCommandArgs& cmdArgs) : ImapCommand(cmdArgs)
    {
    }

    void exec() override
    {
        if (insufficientArguments())
        {
            return completeBadInsufficientArguments();
        }

        if (!alreadyStored())
        {
            imapContext->userData.clientId = ClientID(carg(1));
        }

        sendServerID();
        completeOk();
    }

    bool insufficientArguments() const
    {
        return cargsSize() <= 1;
    }

    bool alreadyStored() const
    {
        return imapContext->userData.clientId != ClientID();
    }

    void sendServerID()
    {
        sendClient() << "* ID (\"name\" \"Yandex Mail\" \"vendor\" \"Yandex\" \"support-url\" "
                        "\"http://feedback.yandex.ru/?from=mail\")\r\n";
    }

    void completeBadInsufficientArguments()
    {
        completeBad("[CLIENTBUG]", "Empty ID argument list");
    }
};

CommandPtr CommandId(ImapCommandArgs& commandArgs)
{
    return CommandPtr(new Id(commandArgs));
}

}
