#include "imap_command.h"

namespace yimap {

struct Logout : ImapCommand
{
    Logout(ImapCommandArgs& cmdArgs) : ImapCommand(cmdArgs)
    {
    }

    void exec() override
    {
        imapContext->sessionState.wasLogout = true;
        completeByeAndOk("IMAP4rev1 Server logging out");
    }
};

CommandPtr CommandLogout(ImapCommandArgs& commandArgs)
{
    return CommandPtr(new Logout(commandArgs));
}

}
