#include "imap_command.h"

#include <backend/misc/spam_report.h>
#include <common/helpers/utf7imap.h>
#include <common/quoted_string.h>
#include <common/sequence_ranges.h>
#include <common/uid_sequence.h>

namespace yimap {

struct MessageTransferBase : ImapSelectedCommand
{
    FolderRef selectedFolder;
    FolderInfo dstFolderInfo;

    MessageTransferBase(ImapCommandArgs& cmdArgs) : ImapSelectedCommand(cmdArgs)
    {
    }

    bool isSpam(const FolderInfo& info)
    {
        return getFoldersCache()->isSpam(info.fid);
    }

    bool isSpam(FolderRef ref)
    {
        return getFoldersCache()->isSpam(ref.fid());
    }

    Future<void> reportSpam(const string& action, UidMapPtr messages)
    {
        return metaBackend->loadBodyMetadata(*messages->toSmidList())
            .then([=, capture_self](auto future) {
                auto bodyMeta = future.get();
                auto spamReport = SpamReport::make(
                    *imapContext,
                    *messages,
                    bodyMeta,
                    action,
                    selectedFolder.info().name,
                    dstFolderInfo.name);
                spamReport->logToTskv();
            });
    }

    string makeCopyuidResponse(const UidSequence& srcUids, const UidSequence& dstUids)
    {
        return "[COPYUID "s + std::to_string(dstFolderInfo.uidValidity) + " "s +
            srcUids.to_string() + " "s + dstUids.to_string() + "]"s;
    }

    FolderListPtr getFoldersCache()
    {
        return imapContext->foldersCache.getFolders();
    }

    void completeEncodingError()
    {
        completeBad("[CLIENTBUG]", "Folder encoding error.");
    }

    void completeNoSuchFolder()
    {
        completeNo("[TRYCREATE]", "No such folder.");
    }
};

}
