#include "imap_command.h"
#include <yplatform/yield.h>

namespace yimap {

struct Noop : ImapCommand
{
    using YieldCtx = yplatform::yield_context<Noop>;

    Noop(ImapCommandArgs& cmdArgs) : ImapCommand(cmdArgs)
    {
    }

    void exec() override
    {
        yplatform::spawn(ioService(), yplatform::shared_from(this));
    }

    void operator()(YieldCtx yieldCtx)
    {
        reenter(yieldCtx)
        {
            yield completeOkAndOutputDiff().then(yieldCtx);
        }
    }

    void operator()(YieldCtx::exception_type exception)
    {
        try
        {
            std::rethrow_exception(exception);
        }
        catch (const std::exception& e)
        {
            completeWithException(e);
        }
    }
};

CommandPtr CommandNoop(ImapCommandArgs& commandArgs)
{
    return CommandPtr(new Noop(commandArgs));
}

}
