#pragma once

#include <common/imap_context.h>
#include <common/settings.h>

namespace yimap {

struct CapabilityResponse
{
    bool notAuthenticated;
    bool sslConnection;
    size_t idle;
    bool notify;
    bool move;
    bool oauth;
    bool starttls;

    CapabilityResponse(const ImapContext& context, const ImapSettings& settings)
    {
        notAuthenticated = context.sessionState.notAuthenticated();
        sslConnection = context.sessionInfo.trustedConnection;
        idle = settings.idleExtension;
        notify = settings.notifyExtension;
        move = settings.moveExtension;
        oauth = settings.oauthExtension;
        starttls = settings.startTLSExtension;
    }

    template <typename Stream>
    Stream& toStream(Stream& stream) const
    {
        stream << "* CAPABILITY IMAP4rev1 CHILDREN UNSELECT LITERAL+ NAMESPACE XLIST BINARY "
                  "UIDPLUS ENABLE ID";
        if (notAuthenticated)
        {
            if (sslConnection)
            {
                stream << " AUTH=PLAIN";
            }
            else if (starttls)
            {
                stream << " STARTTLS LOGINDISABLED";
            }

            if (oauth) stream << " AUTH=XOAUTH2";
        }

        // In 1 mode we announce IDLE after LOGIN
        if (idle == 1) stream << " IDLE";
        if (idle == 2) stream << " IDLE";
        if (notify) stream << " NOTIFY";
        if (move) stream << " MOVE";
        return stream << "\r\n";
    }
};

template <typename Stream>
Stream&& operator<<(Stream&& stream, const CapabilityResponse& response)
{
    response.toStream(stream);
    return std::forward<Stream>(stream);
}

} // namespace yimap
