#pragma once

namespace yimap {

// Expunge response for single message
struct ExpungeResponse
{
    uint64_t modseq;
    uint32_t uid;
    // Real number of message before deletion
    uint32_t num;
    // Number of deleted messages for current revision, with lower uid
    uint64_t modseqShift;

    template <typename Stream>
    Stream& send(Stream& stream) const
    {
        return stream << "* " << (num - modseqShift) << " EXPUNGE\r\n";
    }
};

template <typename Stream>
Stream&& operator<<(Stream&& stream, const ExpungeResponse& response)
{
    response.send(stream);
    return std::forward<Stream>(stream);
}

} // namespace yimap
