#pragma once

#include <common/flags.h>

namespace yimap {

// Expunge response for single message
struct FetchResponse
{
    uint64_t modseq;
    uint32_t uid;
    uint32_t num;
    Flags flags;

    template <typename Stream>
    Stream& send(Stream& stream) const
    {
        return stream << "* " << num << " FETCH (UID " << uid << " FLAGS ("
                      << static_cast<string>(flags) << "))\r\n";
    }
};

template <typename Stream>
Stream&& operator<<(Stream&& stream, const FetchResponse& response)
{
    response.send(stream);
    return std::forward<Stream>(stream);
}

} // namespace yimap
