#include "imap_command.h"
#include <common/settings.h>

namespace yimap {

struct StartTlsImpl : ImapCommand
{
    StartTlsImpl(ImapCommandArgs& cmdArgs) : ImapCommand(cmdArgs)
    {
    }

    void exec() override
    {
        if (!settings_->startTLSExtension)
        {
            completeBad("", "Command syntax error");
            return;
        }

        if (imapContext->sessionInfo.tlsOn)
        {
            completeBad("[CLIENTBUG]", "SSL/TLS already active.");
            return;
        }

        networkSession->asyncStartTLS([this, self = shared_from(this)](auto ec) {
            if (ec)
            {
                networkSession->shutdown();
                promise->set(RET_CLOSE);
            }
            else
            {
                sendClient() << tag() << " OK STARTTLS completed.\r\n";
                imapContext->sessionInfo.sslStatus = "starttls";
                promise->set(RET_OK);
            }
        });
    }
};

CommandPtr CommandStartTls(ImapCommandArgs& commandArgs)
{
    return CommandPtr(new StartTlsImpl(commandArgs));
}

}
