#pragma once

#include <common/types.h>
#include <common/extract_from_quotes.h>

namespace yimap {

struct ClientID
{
    string raw;
    string name;
    string version;
    string OS;
    string OSVersion;
    string vendor;

    ClientID() = default;

    ClientID(const string& raw) : raw(raw)
    {
        auto params = extractQuotedParameterList(raw);
        for (std::size_t i = 0; i + 1 < params.size(); i += 2)
        {
            if (params[i] == "name"s)
            {
                name = params[i + 1];
            }
            else if (params[i] == "version"s)
            {
                version = params[i + 1];
            }
            else if (params[i] == "os"s)
            {
                OS = params[i + 1];
            }
            else if (params[i] == "os-version"s)
            {
                OSVersion = params[i + 1];
            }
            else if (params[i] == "vendor"s)
            {
                vendor = params[i + 1];
            }
        }
    }

    bool operator!=(const ClientID& other) const
    {
        return raw != other.raw;
    }
};

}
