#pragma once

#include <common/types.h>
#include <boost/range.hpp>
#include <string>
#include <sstream>

namespace yimap {

template <typename Range>
string imap_convert_string(Range const& src)
{
    bool quote = false;
    for (const char& c : src)
    {
        if (c == '"' || c == '\\')
        {
            std::ostringstream os;
            os << '{' << src.size() << "}\r\n";
            return os.str() + src;
        }

        if (!quote &&
            !((c >= 'a' && c <= 'z') || (c >= 'A' && c <= 'Z') || (c >= '0' && c <= '9') ||
              c == '.' || c == '-' || c == '_'))
        {
            quote = true;
        }
    }

    if (quote)
    {
        string result("\"");
        result.reserve(src.size() + 1);
        result.append(src.begin(), src.end());
        result.append("\"");
        return result;
    }

    return string(src.begin(), src.end());
}

}
