#pragma once

#include <common/types.h>
#include <boost/crc.hpp>

namespace yimap {
namespace detail {

template <typename T = ::boost::crc_32_type>
class crc_t : public T
{
public:
    inline crc_t(void const* buf, std::size_t sz) : T()
    {
        this->T::process_bytes(buf, sz);
    }
};

template <typename T>
inline typename T::value_type crc_T(void const* buf, std::size_t sz)
{
    crc_t<T> const c(buf, sz);
    return c();
}

} // detail

using CRC32Value = ::boost::crc_32_type::value_type;

inline CRC32Value crc(void const* buf, std::size_t sz)
{
    return detail::crc_T<::boost::crc_32_type>(buf, sz);
}

}
