#pragma once

#include <common/types.h>
#include <stdexcept>

namespace yimap {

struct InvalidFormat : public std::runtime_error
{
    explicit InvalidFormat(const string& reason) : std::runtime_error(reason)
    {
    }
};

struct UnsupportedEncodingError : public std::runtime_error
{
    explicit UnsupportedEncodingError() : std::runtime_error("Unsupported text encoding")
    {
    }
};

struct InvalidSeqSet : public std::runtime_error
{
    explicit InvalidSeqSet() : std::runtime_error("invalid seqset")
    {
    }
};

struct ParseDateError : std::runtime_error
{
    ParseDateError() : std::runtime_error("")
    {
    }
};

struct NoBodyError : std::runtime_error
{
    NoBodyError() : std::runtime_error("")
    {
    }
};

struct BackendError : public std::runtime_error
{
    explicit BackendError(const string& reason) : std::runtime_error(reason)
    {
    }
};

}