#pragma once

#include <common/types.h>
#include <vector>

namespace yimap {

// Extract values from string "\"fst\" \"snd\" \"thrd\"" to vector {"fst", "snd", "thrd"}
inline std::vector<string> extractQuotedParameterList(const string& str)
{
    std::vector<string> ret;
    auto leftQuote = string::npos;
    for (std::size_t i = 0; i < str.size(); ++i)
    {
        if (str[i] == '"')
        {
            if (leftQuote == string::npos)
            {
                leftQuote = i;
            }
            else
            {
                auto rightQuote = i;
                ret.emplace_back(str.substr(leftQuote + 1, rightQuote - leftQuote - 1));
                leftQuote = string::npos;
            }
        }
    }
    return ret;
}

}