#include <common/types.h>
#include <common/flags.h>

#include <boost/bind.hpp>

namespace yimap {

void Flags::setFlag(MessageFlag const& f)
{
    stdFlags_ = stdFlags_ | (1 << f);
}

void Flags::delFlag(MessageFlag const& f)
{
    stdFlags_ &= ~(1 << f);
}

namespace detail {

static void addFlagToString(string& dst, string const& src)
{
    if (!dst.empty()) dst += ' ';
    dst += src;
}

}

Flags::operator string() const
{
    string ret;
    forEachFlag(std::bind(&detail::addFlagToString, std::ref(ret), std::placeholders::_1));
    return ret;
}

void Flags::forEachFlag(std::function<void(const string&)> hook) const
{
    if (hasFlag(MSG_SEEN)) hook("\\Seen");
    if (hasFlag(MSG_ANSWERED)) hook("\\Answered");
    if (hasFlag(MSG_FLAGGED)) hook("\\Flagged");
    if (hasFlag(MSG_DELETED)) hook("\\Deleted");
    if (hasFlag(MSG_DRAFT)) hook("\\Draft");
    if (hasFlag(MSG_RECENT)) hook("\\Recent");
    if (hasFlag(MSG_FORWARDED)) hook("$Forwarded");

    for (const auto& flag : userFlags_)
    {
        hook(flag);
    }
}

void Flags::addFlags(Flags const& flags)
{
    stdFlags_ = stdFlags_ | flags.stdFlags_;
    for (string const& flag : flags.userFlags_)
    {
        setFlag(flag);
    }
}

void Flags::delFlags(Flags const& flags)
{
    stdFlags_ &= ~flags.stdFlags_;

    for (string const& flag : flags.userFlags_)
    {
        delFlag(flag);
    }
}

}
