#pragma once

#include <boost/shared_ptr.hpp>
#include <boost/cstdint.hpp>
#include <string>

namespace yimap {

// Exact copy of macs::ImapFolder;
struct FolderInfo
{
    std::string name;
    std::string fid;
    std::string fsuid;

    uint32_t revision = 0u;
    uint32_t messageCount = 0u;
    uint32_t recentCount = 0u;
    uint32_t unseenCount = 0u;
    uint32_t uidNext = 0u;
    uint32_t uidValidity = 0u;
    uint32_t firstUnseen = 0u;

    bool recentChanged = false;

    uint32_t sysdate = 0u;
    uint32_t changed = 0u;
    uint32_t mapChanged = 0u;

    bool changesOlderThan(uint32_t timeDeltaSeconds)
    {
        return sysdate - changed > timeDeltaSeconds;
    }

    bool operator==(const FolderInfo& other) const
    {
        return std::tie(
                   name,
                   fid,
                   fsuid,
                   revision,
                   messageCount,
                   recentCount,
                   unseenCount,
                   uidNext,
                   uidValidity,
                   firstUnseen,
                   recentChanged,
                   sysdate,
                   changed,
                   mapChanged) ==
            std::tie(
                   other.name,
                   other.fid,
                   other.fsuid,
                   other.revision,
                   other.messageCount,
                   other.recentCount,
                   other.unseenCount,
                   other.uidNext,
                   other.uidValidity,
                   other.firstUnseen,
                   other.recentChanged,
                   other.sysdate,
                   other.changed,
                   other.mapChanged);
    }
};

class FullFolderInfo
{
public:
    std::string name;
    std::string fid;
    std::string fsuid;

    uint64_t revision = 0u;
    uint64_t messageCount = 0u;
    uint64_t recentCount = 0u;
    uint64_t unseenCount = 0u;
    uint64_t uidNext = 0u;
    uint64_t uidValidity = 0u;
    uint64_t firstUnseen = 0u;

    std::string symbol;

    uint64_t bytes = 0u;
    uint64_t highestModseq = 0u;
    uint64_t lastDeletedModseq = 0u;
    bool isShared = false;

    bool recent = false;
    bool subscribed = true;
    bool userFlagsSupport = true;
    mutable bool hasChildren = false;
};

typedef std::shared_ptr<FolderInfo> FolderInfoPtr;
typedef std::shared_ptr<FullFolderInfo> FullFolderInfoPtr;

}
