#include "helpers.h"

#include <ctime>
#include <sstream>
#include <time.h>

namespace yimap {

std::string createErrorSuffix(const std::string& uniqId)
{
    std::time_t now = std::time(nullptr);
    tm tmTime;
    ::gmtime_r(&now, &tmTime);
    char timeBuff[16] = "";
    std::strftime(timeBuff, sizeof(timeBuff), "%d%H%M", &tmTime);

    std::ostringstream resultStream;
    resultStream << " sc=" << uniqId << "_" << timeBuff << "_" << HostId::create().suffix;
    return resultStream.str();
}

size_t makePoweredByTwo(size_t input, size_t minPow)
{
    const size_t defaultValue = 1 << minPow;

    if (input < defaultValue)
    {
        return defaultValue;
    }

    size_t res = input;
    if ((res & (res - 1)) == 0)
    {
        return res;
    }

    while ((res & (res - 1)) != 0)
    {
        res++;
    }
    return res;
}

} // namespace yimap
