#pragma once

#include <string>

namespace yimap {

//-----------------------------------------------------------------------------
// Common helpers

struct HostId
{
    std::string hostName;
    std::string suffix;

    static HostId create();
    static HostId parse(const std::string& hostName);

private:
    HostId(const std::string& hostName, const std::string& suffix);
};

std::string createErrorSuffix(const std::string& uniqId);

size_t makePoweredByTwo(size_t input, size_t minPow = 10);

} // namespace yimap
