#pragma once

#include <string>
#include <stdexcept>

namespace yimap {

// Convert folder name, part by bart, to utf-7-imap from utf-8.
std::string folderNameToUtf7Imap(const std::string& folderName, char delim);

// Convert folder name, part by bart, from utf-7-imap to utf-8.
std::string folderNameFromUtf7Imap(const std::string& folderName, char delim);

struct Utf7EncodingError : public std::runtime_error
{
    explicit Utf7EncodingError(const std::string& reason) : runtime_error(reason)
    {
    }
};

} // namespace yimap
