#include <common/imap_context.h>
#include <yplatform/net/handlers/timer_handler.h>
#include <boost/property_tree/ptree.hpp>
#include <boost/thread/locks.hpp>
#include <iostream>

namespace yimap {

boost::shared_ptr<boost::property_tree::ptree> ImapContext::core_get_stat() const
{
    ptree_ptr result = Context::core_get_stat();

    result->put("state", sessionState.state_name());

    result->put(
        "local_addr",
        sessionInfo.localAddress + ":" + boost::lexical_cast<string>(sessionInfo.localPort));
    result->put(
        "remote_addr",
        sessionInfo.remoteAddress + ":" + boost::lexical_cast<string>(sessionInfo.remotePort));

    result->put("tls", sessionInfo.tlsOn);
    result->put("now_processing", 0 /* now_processing */);
    result->put("auth.username", userData.login);
    result->put("auth.suid", userData.suid);
    result->put("auth.uid", userData.uid);
    result->put("auth.storage", userData.storage);
    result->put("auth.login", userData.login);
    result->put("auth.email", userData.email);

    // XXX thread unsafe
    // {
    //     if (selectedFolderInfo) {
    //         result->put("folder.fid", selectedFolderInfo->fid);
    //         result->put("folder.name", selectedFolderInfo->name);
    //         result->put("folder.revision", selectedFolderInfo->revision);
    //     }
    // }

    return result;
}

TimerPtr createTimer(ImapContextPtr ctx, Duration timeout, VoidFunction hook)
{
    TimerPtr timer(new Timer(ctx->ioService));
    timer->expires_from_now(timeout);
    timer->async_wait(yplatform::net::create_timer_handler(hook));
    return timer;
}

TimerPtr createTimer(ImapContextPtr ctx, Duration timeout)
{
    TimerPtr timer(new Timer(ctx->ioService));
    timer->expires_from_now(timeout);
    return timer;
}

} // yimap
