#pragma once

#include <common/types.h>
#include <common/user_settings.h>
#include <map>

//-----------------------------------------------------------------------------
// Localization settings helper structure

namespace yimap {

struct FolderNameEntry
{
    std::string symbol;
    std::string name;
    std::string xlist;
};

class LanguageConfig
{
public:
    using SymbolMap = std::map<std::string, FolderNameEntry>;
    LanguageConfig();
    LanguageConfig(const Ptree& xml, const UserSettings& userSettings, const std::string& language);

    std::string nameFromSymbol(const std::string& folderSymbol) const;
    std::string xlistFromSymbol(const std::string& folderSymbol) const;

protected:
    SymbolMap getLanguageMapping(const Ptree& xml, const std::string& targetLanguage);

    bool renameEnabled = false;
    bool localize = false;
    SymbolMap symbolToFolder;

    // Default english localization if no special config for given language was found
    static const SymbolMap englishMapping;
    // Configuration used to show folder names from database as is
    static const SymbolMap databaseMapping;
};

} // namespace yimap
