#pragma once
#include <sstream>

namespace yimap {

namespace lex_ids {

enum ids
{
    _FIRST,
    UNKNOWN,
    USERID,
    PASSWORD,
    STRING,
    LITERAL,
    ASTRING,
    MAILBOX,
    NUMBER,
    NZ_NUMBER,
    ADDRESS,
    ADDR_ADL,
    ADDR_HOST,
    ADDR_MAILBOX,
    ADDR_NAME,
    ASTRING_CHAR,
    ATOM,
    ATOM_CHAR,
    ATOM_SPECIALS,
    AUTH_TYPE,
    BASE64,
    BASE64_CHAR,
    BASE64_TERMINAL,
    BODY,
    BODY_EXTENSION,
    BODY_EXT_1PART,
    BODY_EXT_MPART,
    BODY_FIELDS,
    BODY_FLD_DESC,
    BODY_FLD_DSP,
    BODY_FLD_ENC,
    BODY_FLD_ID,
    BODY_FLD_LANG,
    BODY_FLD_LOC,
    BODY_FLD_LINES,
    BODY_FLD_MD5,
    BODY_FLD_OCTETS,
    BODY_FLD_PARAM,
    BODY_TYPE_1PART,
    BODY_TYPE_BASIC,
    BODY_TYPE_MPART,
    BODY_TYPE_MSG,
    BODY_TYPE_TEXT,
    CAPABILITY,
    CAPABILITY_DATA,
    CHAR8,
    COMMAND_ANY,
    COMMAND_AUTH,
    COMMAND_NONAUTH,
    COMMAND_SELECT,
    CONTINUE_REQ,
    DATE,
    DATE_TIME,
    DIGIT_NZ,
    ENVELOPE,
    ENV_BCC,
    ENV_CC,
    ENV_DATE,
    ENV_FROM,
    ENV_IN_REPLY_TO,
    ENV_MESSAGE_ID,
    ENV_REPLY_TO,
    ENV_SENDER,
    ENV_SUBJECT,
    ENV_TO,
    FETCH_ATTS,
    FETCH_ATT,
    FETCH_ATT_ENVELOPE,
    FETCH_ATT_FLAGS,
    FETCH_ATT_INTERNALDATE,
    FETCH_ATT_RFC822,
    FETCH_ATT_RFC822_HEADER,
    FETCH_ATT_RFC822_SIZE,
    FETCH_ATT_RFC822_TEXT,
    FETCH_ATT_UID,
    FETCH_ATT_BINARY_PEEK,
    FETCH_ATT_BINARY_SIZE,
    FETCH_ATT_BINARY,
    FETCH_ATT_BODY_PEEK,
    FETCH_ATT_BODY,
    FETCH_ATT_BODY_STRUCTURE,
    FETCH_ATT_BODY_STRUCTURE_NONEXT,
    FETCH_ATT_XMID,
    FETCH_ATT_XSTID,
    FETCH_MACRO_ALL,
    FETCH_MACRO_FULL,
    FETCH_MACRO_FAST,
    FLAG,
    FLAG_EXTENSION,
    FLAG_FETCH,
    FLAG_KEYWORD,
    FLAG_LIST,
    FLAG_PERM,
    ID_PARAMS_LIST,
    GREETING,
    HEADER_FLD_NAME,
    HEADER_LIST,
    LIST,
    LIST_MAILBOX,
    LIST_CHAR,
    LIST_WILDCARDS,
    MAILBOX_DATA,
    MAILBOX_LIST,
    MBX_LIST_FLAGS,
    MBX_LIST_OFLAG,
    MBX_LIST_SFLAG,
    MEDIA_BASIC,
    MEDIA_MESSAGE,
    MEDIA_SUBTYPE,
    MEDIA_TEXT,
    MESSAGE_DATA,
    MSG_ATT,
    MSG_ATT_DYNAMIC,
    MSG_ATT_STATIC,
    NIL,
    NSTRING,
    QUOTED,
    QUOTED_CHAR,
    QUOTED_SPECIALS,
    RESPONSE,
    RESPONSE_DATA,
    RESPONSE_DONE,
    RESPONSE_FATAL,
    RESPONSE_TAGGED,
    RESP_COND_AUTH,
    RESP_COND_BYE,
    RESP_COND_STATE,
    RESP_SPECIALS,
    RESP_TEXT,
    RESP_TEXT_CODE,
    RFC822_MESSAGE, // used in append
    SEARCH_KEY,
    SEARCH_CHARSET,
    SEARCH_KEY_ALL,
    SEARCH_KEY_ANSWERED,
    SEARCH_KEY_BCC,
    SEARCH_KEY_BEFORE,
    SEARCH_KEY_BODY,
    SEARCH_KEY_CC,
    SEARCH_KEY_DELETED,
    SEARCH_KEY_FLAGGED,
    SEARCH_KEY_FROM,
    SEARCH_KEY_KEYWORD,
    SEARCH_KEY_NEW,
    SEARCH_KEY_OLD,
    SEARCH_KEY_ON,
    SEARCH_KEY_RECENT,
    SEARCH_KEY_SEEN,
    SEARCH_KEY_SINCE,
    SEARCH_KEY_SUBJECT,
    SEARCH_KEY_TEXT,
    SEARCH_KEY_TO,
    SEARCH_KEY_UNANSWERED,
    SEARCH_KEY_UNDELETED,
    SEARCH_KEY_UNFLAGGED,
    SEARCH_KEY_UNKEYWORD,
    SEARCH_KEY_UNSEEN,
    SEARCH_KEY_DRAFT,
    SEARCH_KEY_HEADER,
    SEARCH_KEY_LARGER,
    SEARCH_KEY_NOT,
    SEARCH_KEY_OR,
    SEARCH_KEY_SENTBEFORE,
    SEARCH_KEY_SENTON,
    SEARCH_KEY_SENTSINCE,
    SEARCH_KEY_SMALLER,
    SEARCH_KEY_UID,
    SEARCH_KEY_UNDRAFT,
    SEARCH_KEY_SEQSET,
    SEARCH_KEY_AND,
    SECTION,
    SECTION_RANGE,
    SECTION_MSGTEXT,
    SECTION_PART,
    SECTION_SPEC,
    SECTION_TEXT,
    SECTION_MSG_HEADER_FIELDS_NOT,
    SECTION_MSG_HEADER_FIELDS,
    SECTION_MSG_HEADER,
    SECTION_MSG_TEXT,
    SECTION_TEXT_MIME,
    SEQ_NUMBER,
    SEQ_NUMBER_LAST,
    SEQ_RANGE,
    STATUS_ATT,
    STATUS_ATTS,
    STATUS_ATT_MESSAGES,
    STATUS_ATT_RECENT,
    STATUS_ATT_UIDNEXT,
    STATUS_ATT_UIDVALIDITY,
    STATUS_ATT_UNSEEN,
    STATUS_ATT_LIST,
    STORE_ATT_SET_FLAGS,
    STORE_ATT_ADD_FLAGS,
    STORE_ATT_DEL_FLAGS,
    STORE_ATT_SILENT,
    STORE_ATT_VERBOSE,
    TEXT,
    TEXT_CHAR,
    UNIQUEID,
    X_COMMAND,
    SEQUENCE_SET,
    SEQUENCE_SET_TMP,
    TAG,
    COMMAND,
    CMD_CAPABILITY,
    CMD_LOGOUT,
    CMD_NOOP,
    CMD_ID,
    CMD_IDLE,
    CMD_APPEND,
    CMD_CREATE,
    CMD_DELETE,
    CMD_ENABLE,
    CMD_EXAMINE,
    CMD_LIST,
    CMD_LSUB,
    CMD_RENAME,
    CMD_SELECT,
    CMD_STATUS,
    CMD_SUBSCRIBE,
    CMD_UNSUBSCRIBE,
    CMD_LOGIN,
    CMD_AUTHENTICATE,
    CMD_STARTTLS,
    CMD_CHECK,
    CMD_CLOSE,
    CMD_EXPUNGE,
    CMD_UID_EXPUNGE,
    CMD_COPY,
    CMD_MOVE,
    CMD_FETCH,
    CMD_STORE,
    CMD_UID,
    CMD_SEARCH,
    CMD_UNSELECT,
    CMD_NAMESPACE,
    CMD_X_LIST,

    // NOTIFY extension
    NOTIFY_NONE,
    NOTIFY_SET,
    STATUS_INDICATOR,
    EVENT_GROUPS,
    EVENT_GROUP,
    FILTER_MAILBOXES,
    FILTER_MAILBOXES_OTHER,
    FILTER_MAILBOXES_SELECTED,
    ONE_OR_MORE_MAILBOX,
    MANY_MAILBOXES,
    EVENTS,
    EVENT,
    MESSAGE_EVENT,
    MAILBOX_EVENT,
    USER_EVENT,
    EVENT_EXT,

    _LAST
}; // enum

namespace {
const char* id2str[] = { "<first>",
                         "<unknown>",
                         "userid",
                         "password",
                         "string",
                         "literal",
                         "astring",
                         "mailbox",
                         "number",
                         "nz_number",
                         "address",
                         "addr_adl",
                         "addr_host",
                         "addr_mailbox",
                         "addr_name",
                         "astring_char",
                         "atom",
                         "atom_char",
                         "atom_specials",
                         "auth_type",
                         "base64",
                         "base64_char",
                         "base64_terminal",
                         "body",
                         "body_extension",
                         "body_ext_1part",
                         "body_ext_mpart",
                         "body_fields",
                         "body_fld_desc",
                         "body_fld_dsp",
                         "body_fld_enc",
                         "body_fld_id",
                         "body_fld_lang",
                         "body_fld_loc",
                         "body_fld_lines",
                         "body_fld_md5",
                         "body_fld_octets",
                         "body_fld_param",
                         "body_type_1part",
                         "body_type_basic",
                         "body_type_mpart",
                         "body_type_msg",
                         "body_type_text",
                         "capability",
                         "capability_data",
                         "char8",
                         "command_any",
                         "command_auth",
                         "command_nonauth",
                         "command_select",
                         "continue_req",
                         "date",
                         "date_time",
                         "digit_nz",
                         "envelope",
                         "env_bcc",
                         "env_cc",
                         "env_date",
                         "env_from",
                         "env_in_reply_to",
                         "env_message_id",
                         "env_reply_to",
                         "env_sender",
                         "env_subject",
                         "env_to",
                         "fetch_atts",
                         "fetch_att",
                         "fetch_att_envelope",
                         "fetch_att_flags",
                         "fetch_att_internaldate",
                         "fetch_att_rfc822",
                         "fetch_att_rfc822_header",
                         "fetch_att_rfc822_size",
                         "fetch_att_rfc822_text",
                         "fetch_att_uid",
                         "fetch_att_binary_peek",
                         "fetch_att_binary_size",
                         "fetch_att_binary",
                         "fetch_att_body_peek",
                         "fetch_att_body",
                         "fetch_att_body_structure",
                         "fetch_att_body_structure_nonext",
                         "fetch_att_xmid",
                         "fetch_att_xstid",
                         "fetch_macro_all",
                         "fetch_macro_full",
                         "fetch_macro_fast",
                         "flag",
                         "flag_extension",
                         "flag_fetch",
                         "flag_keyword",
                         "flag_list",
                         "flag_perm",
                         "id_param_list",
                         "greeting",
                         "header_fld_name",
                         "header_list",
                         "list",
                         "list_mailbox",
                         "list_char",
                         "list_wildcards",
                         "mailbox_data",
                         "mailbox_list",
                         "mbx_list_flags",
                         "mbx_list_oflag",
                         "mbx_list_sflag",
                         "media_basic",
                         "media_message",
                         "media_subtype",
                         "media_text",
                         "message_data",
                         "msg_att",
                         "msg_att_dynamic",
                         "msg_att_static",
                         "nil",
                         "nstring",
                         "quoted",
                         "quoted_char",
                         "quoted_specials",
                         "response",
                         "response_data",
                         "response_done",
                         "response_fatal",
                         "response_tagged",
                         "resp_cond_auth",
                         "resp_cond_bye",
                         "resp_cond_state",
                         "resp_specials",
                         "resp_text",
                         "resp_text_code",
                         "rfc822_message",
                         "search_key",
                         "search_charset",
                         "search_key_all",
                         "search_key_answered",
                         "search_key_bcc",
                         "search_key_before",
                         "search_key_body",
                         "search_key_cc",
                         "search_key_deleted",
                         "search_key_flagged",
                         "search_key_from",
                         "search_key_keyword",
                         "search_key_new",
                         "search_key_old",
                         "search_key_on",
                         "search_key_recent",
                         "search_key_seen",
                         "search_key_since",
                         "search_key_subject",
                         "search_key_text",
                         "search_key_to",
                         "search_key_unanswered",
                         "search_key_undeleted",
                         "search_key_unflagged",
                         "search_key_unkeyword",
                         "search_key_unseen",
                         "search_key_draft",
                         "search_key_header",
                         "search_key_larger",
                         "search_key_not",
                         "search_key_or",
                         "search_key_sentbefore",
                         "search_key_senton",
                         "search_key_sentsince",
                         "search_key_smaller",
                         "search_key_uid",
                         "search_key_undraft",
                         "search_key_seqset",
                         "search_key_and",
                         "section",
                         "section_range",
                         "section_msgtext",
                         "section_part",
                         "section_spec",
                         "section_text",
                         "section_msg_header_fields_not",
                         "section_msg_header_fields",
                         "section_msg_header",
                         "section_msg_text",
                         "section_text_mime",
                         "seq_number",
                         "seq_number_last",
                         "seq_range",
                         "status_att",
                         "status_atts",
                         "status_att_messages",
                         "status_att_recent",
                         "status_att_uidnext",
                         "status_att_uidvalidity",
                         "status_att_unseen",
                         "status_att_list",
                         "store_att_set_flags",
                         "store_att_add_flags",
                         "store_att_del_flags",
                         "store_att_silent",
                         "store_att_verbose",
                         "text",
                         "text_char",
                         "uniqueid",
                         //  "x_command",
                         "sequence_set",
                         "sequence_set_tmp",
                         "tag",
                         "command",
                         "cmd_capability",
                         "cmd_logout",
                         "cmd_noop",
                         "cmd_id",
                         "cmd_idle",
                         "cmd_append",
                         "cmd_create",
                         "cmd_delete",
                         "cmd_enable",
                         "cmd_examine",
                         "cmd_list",
                         "cmd_lsub",
                         "cmd_rename",
                         "cmd_select",
                         "cmd_status",
                         "cmd_subscribe",
                         "cmd_unsubscribe",
                         "cmd_login",
                         "cmd_authenticate",
                         "cmd_starttls",
                         "cmd_check",
                         "cmd_close",
                         "cmd_expunge",
                         "cmd_uid_expunge",
                         "cmd_copy",
                         "cmd_move",
                         "cmd_fetch",
                         "cmd_store",
                         "cmd_uid",
                         "cmd_search",
                         "cmd_unselect",
                         "cmd_namespace",
                         "cmd_x_list",

                         // Notify extension
                         "notify_none",
                         "notify_set",
                         "status_indicator",
                         "event_groups",
                         "event_group",
                         "filter_mailboxes",
                         "filter_mailboxes_other",
                         "filter_mailboxes_selected",
                         "one_or_more_mailbox",
                         "many_mailboxes",
                         "events",
                         "event",
                         "message_event",
                         "mailbox_event",
                         "user_event",
                         "event_ext",

                         "<last>" };
} // anon namespace

} // namespace lex_ids

inline std::string lex_id_to_str(int i)
{
    if (i > 0 && i < lex_ids::_LAST) return std::string(lex_ids::id2str[i]);

    std::ostringstream os;
    os << "#" << i;
    return os.str();
}

}
