#pragma once

#include <sstream>

namespace yimap {

using namespace std;

class Logger;

struct LogHelper
{
    enum
    {
        LH_LOG_CLIENTS = 0,
        LH_LOG_DISCARD = 1 << 0,
        LH_LOG_SYSTEM = 1 << 1,
        LH_LOG_ERROR = 1 << 2,
        LH_LOG_DEBUG = 1 << 3,
        LH_LOG_WARNING = 1 << 4
    };

    explicit LogHelper(const string& prefix, size_t flags, Logger& aLogger)
        : logger(&aLogger), prefix(prefix), hasData(false), flags(flags)
    {
        sstream << prefix;
    }
    LogHelper(
        Logger& aLogger,
        const string& prefix = "",
        bool systemLog = false,
        bool errorLog = false,
        bool warningLog = false)
        : logger(&aLogger)
        , prefix(prefix)
        , hasData(false)
        , flags(
              (systemLog ? LH_LOG_SYSTEM : 0) | (errorLog ? LH_LOG_ERROR : 0) |
              (warningLog ? LH_LOG_WARNING : 0))
    {
        sstream << prefix;
    }

    LogHelper(const LogHelper& that)
        : logger(that.logger), prefix(that.prefix), hasData(false), flags(that.flags)
    {
        sstream << prefix;
    }

    virtual ~LogHelper();

    template <typename T>
    LogHelper& operator<<(const T& x)
    {
        if (flags & LH_LOG_DISCARD) return *this;
        hasData = true;
        sstream << x;
        return *this;
    }

    bool active() const
    {
        return !flags & LH_LOG_DISCARD;
    }

private:
    std::stringstream sstream;
    Logger* logger;
    string prefix;
    bool hasData;
    size_t flags;

    LogHelper& operator=(const LogHelper&);
};

} // namespace yimap
