#pragma once

#include "log_helper.h"
#include <common/types.h>
#include <common/short_session_info.h>
#include <common/zerocopy.h>

namespace yimap {

typedef boost::optional<string> StringOpt;

class Logger
{
public:
    virtual ~Logger()
    {
    }

    virtual void updateSessionInfo(const ShortSessionInfo& newSessionInfo) = 0;
    virtual void enableClientLog()
    {
    }

    virtual LogHelper log(bool systemLog = false, bool errorLog = false);
    virtual LogHelper logError();
    virtual LogHelper logEvent();
    virtual LogHelper logWarning();

    virtual void logString(const string&, size_t flags = 0) = 0;
    virtual void logTiming(const string& /* message */) = 0;
    virtual void logCommand(const zerocopy::SegmentRange&) const = 0;
    virtual void logTraffic(const string& /* message */) = 0;

    virtual LogHelper logDebug() = 0;
    virtual LogHelper logDebugNet() = 0;
};

} // namespace yimap
