#pragma once

#include <common/uid_map.h>
#include <common/folder_info.h>

#include <vector>
#include <map>

namespace yimap {

using namespace std;

class MailboxDiff
{
public:
    typedef MessageSet::const_iterator const_iterator;
    typedef MessageSet::iterator iterator;

    MailboxDiff(const FolderInfo& aFolderInfo);
    MailboxDiff(
        const FolderInfo& aFolderInfo,
        const MessageVector& deleted,
        const MessageVector& changed,
        const MessageVector& added);

    void drop(const FolderInfo&);

    // Add  all changes from other, with revision greater than current revision.
    void update(MailboxDiff& other);
    void setFolderInfo(const FolderInfo& folderInfo);

    const FolderInfo& folderInfo() const
    {
        return currentFolderInfo;
    }
    uint32_t revision() const
    {
        return currentFolderInfo.revision;
    }
    uint32_t fromRevision() const
    {
        return initialRevision;
    }

    bool empty() const
    {
        return history.empty();
    }
    bool hasAdded() const
    {
        return addedCount > 0;
    }

    uint32_t messageCount() const
    {
        return currentFolderInfo.messageCount;
    }
    uint32_t recentCount() const
    {
        return currentFolderInfo.recentCount;
    }
    uint32_t recentChanged() const
    {
        return currentFolderInfo.recentChanged;
    }
    void setRecentChanged(bool on)
    {
        currentFolderInfo.recentChanged = on;
    }

protected:
    void addMessage(const MessageData& msg);
    void addDeleted(const MessageData& msg);
    void addChanged(const MessageData& msg);
    void addAdded(const MessageData& msg);

    uint32_t addedCount;
    uint32_t initialRevision;
    FolderInfo currentFolderInfo;

    MessageMultiSet history;

public:
    MessageSet changed;
    MessageSet deleted;
};

typedef std::shared_ptr<MailboxDiff> MailboxDiffPtr;

}
