#include <common/message_set.h>
#include <boost/pool/object_pool.hpp>

#include <algorithm>
#include <iostream>

namespace yimap {

void MessageVector::sortByRevision()
{
    std::sort(begin(), end(), CompareByRevisionAndUid());
}
void MessageVector::sortByUid()
{
    std::sort(begin(), end(), CompareMsgByUid());
}

MidSet MessageVector::asMidSet() const
{
    MidSet result;
    std::transform(begin(), end(), std::inserter(result, result.end()), MessageData::takeMid);
    return result;
}

} // namespace yimap
