#pragma once

#include <common/commands.h>
#include <common/tree.h>
#include <yplatform/encoding/iterators/quoted_string.h>
#include <boost/range.hpp>

namespace yimap {

template <typename NodeValue>
boost::iterator_range<yplatform::quoted_string_iterator<typename NodeValue::const_iterator_t>>
quoted_range(NodeValue const& node)
{
    typedef yplatform::quoted_string_iterator<typename NodeValue::const_iterator_t> iterator;
    bool on = (boost::get<int>(node.value()) == LEX_QUOTED);

    return boost::iterator_range<iterator>(iterator(node.begin(), on), iterator(node.end(), false));
}

inline boost::iterator_range<
    yplatform::quoted_string_iterator<TreeNode::parse_node_t::const_iterator_t>>
quoted_range(TreeNode const& node)
{
    return quoted_range<TreeNode::parse_node_t>(node.value);
}

template <typename Node>
string quoted_string(Node const& node)
{
    return boost::copy_range<string>(quoted_range(node));
}

}
