#pragma once

#include <common/types.h>

namespace yimap {

struct SessionInfo
{
    std::string localAddress;
    unsigned short localPort;

    std::string remoteAddress;
    unsigned short remotePort;

    bool tlsOn = false;
    bool trustedConnection = false;
    string sslStatus = "no";
    string sslChipher;

    SessionInfo() = default;

    template <typename EndPoint>
    SessionInfo(const EndPoint& local, const EndPoint& remote)
        : localAddress(local.address().to_string())
        , localPort(local.port())
        , remoteAddress(remote.address().to_string())
        , remotePort(remote.port())
    {
    }
};

}
