#pragma once

#include <common/types.h>
#include <common/user_data.h>

namespace yimap {

struct ShortSessionInfo
{
    ShortSessionInfo() = default;
    ShortSessionInfo(const std::string& uniqId) : uniqId(uniqId)
    {
    }
    ShortSessionInfo(
        const std::string& uniqId,
        const UserData& userData,
        const std::string& clientIp,
        size_t clientPort)
        : userData(userData)
        , uniqId(uniqId)
        , clientIp(clientIp)
        , clientPort(clientPort)
        , cachedPrefix(
              uniqId + " [" + userData.login + "," + userData.uid + "," + clientIp + "," +
              userData.storage + "] ")
    {
    }

    UserData userData;
    std::string uniqId;
    std::string clientIp;
    size_t clientPort;

    string logPrefix() const
    {
        return cachedPrefix;
    }

private:
    string cachedPrefix;
};

}
